IF (SELECT COUNT(*) FROM TEMPDB..SYSOBJECTS WHERE NAME = '##STOREINDEXINFORMATION') > 0
  BEGIN
	DROP TABLE ##STOREINDEXINFORMATION
  END

SELECT	IDENT = IDENTITY (INT,1,1)
		,SC.[TABLE_SCHEMA]
		,SC.[TABLE_NAME] 
		,SI.[NAME] [INDEXNAME]
INTO	##STOREINDEXINFORMATION
FROM	SYS.INDEXES I 
JOIN SYS.TABLES T ON I.[OBJECT_ID] = T.[OBJECT_ID] 
JOIN SYSINDEXES SI ON SI.ID = T.[OBJECT_ID] 
JOIN INFORMATION_SCHEMA.TABLES SC ON SC.TABLE_NAME = OBJECT_NAME (T.[OBJECT_ID])
JOIN dbo.SQLDICTIONARY SD ON SD.SQLNAME = SC.TABLE_NAME and SD.FIELDID = 0
WHERE	I.[INDEX_ID] > 1 
		AND		I.[TYPE] = 2 
		AND		I.[IS_UNIQUE] = 1
		AND		I.[INDEX_ID] = SI.INDID

DECLARE @VAR1 INT
DECLARE @TOTALCOUNT INT
DECLARE @COUNT INT
SET  	@TOTALCOUNT = 0
SET		@COUNT  = 0

PRINT 'Started disabling all unique indexes...'

SET @VAR1 = 1
WHILE @VAR1 < = ( SELECT COUNT(*) FROM ##STOREINDEXINFORMATION)
BEGIN 
	DECLARE @OBJECTNAME VARCHAR(256)
	DECLARE @INDEXNAME VARCHAR(128)
	DECLARE @ISCHANGETRACKINGTABLE INT
	DECLARE @SQLCMD VARCHAR(1000)
	

	SELECT	@OBJECTNAME = [TABLE_SCHEMA]+'.'+[TABLE_NAME]
			, @INDEXNAME = [INDEXNAME] 
			, @ISCHANGETRACKINGTABLE = ctt.object_id
	FROM	##STOREINDEXINFORMATION 
	
	LEFT OUTER JOIN sys.tables t ON t.name = ##STOREINDEXINFORMATION.TABLE_NAME-- ctt.object_id = t.object_id
	LEFT OUTER JOIN sys.schemas s ON t.schema_id = s.schema_id and s.name = ##STOREINDEXINFORMATION.TABLE_SCHEMA
	LEFT OUTER JOIN sys.change_tracking_tables ctt ON ctt.object_id = t.object_id
	WHERE	[IDENT] = @VAR1
	
	
 
	IF(@ISCHANGETRACKINGTABLE > 0)
	BEGIN
		SET @SQLCMD ='ALTER TABLE '+@OBJECTNAME+' DISABLE CHANGE_TRACKING '
		PRINT @SQLCMD
		EXEC (@SQLCMD)
	END
	
	BEGIN
	SET @SQLCMD ='ALTER INDEX '+@INDEXNAME +' ON '+@OBJECTNAME+' DISABLE '
	PRINT @SQLCMD
	EXEC (@SQLCMD)
	END

	  IF(@ISCHANGETRACKINGTABLE > 0)
	BEGIN
		SET @SQLCMD ='ALTER TABLE '+@OBJECTNAME+' ENABLE CHANGE_TRACKING WITH (TRACK_COLUMNS_UPDATED = ON) '
		PRINT @SQLCMD
		EXEC (@SQLCMD)
	END
	
		SET @TOTALCOUNT = @TOTALCOUNT + @COUNT 

	SET @VAR1 = @VAR1 + 1
	
	IF (SELECT COUNT(*) FROM ##STOREINDEXINFORMATION )= @VAR1 
	 BEGIN
		SET @TOTALCOUNT = @VAR1
	 END
END

IF @TOTALCOUNT = (SELECT COUNT(*) FROM ##STOREINDEXINFORMATION)
  BEGIN
	PRINT 'Successfully finished disabling all unique indexes for '+DB_NAME()+' database'
  END 
	
IF @TOTALCOUNT <> (SELECT COUNT(*) FROM ##STOREINDEXINFORMATION)
  BEGIN
	print @TOTALCOUNT
	PRINT 'Could not disable all unique index due to some reason for more information check sql server logs'
  END