

#############################################################
# This script does the following:
# 1. Stop ALL D365 services
# 2. Restore the backup file to the target DB
# 3. Start ALL target AOS services
#############################################################

$currentPath = Split-Path((Get-Variable MyInvocation -Scope 0).Value).MyCommand.Path
"Current path is " + $currentPath

$environmentFileName = $currentPath + "\EnvironmentSettings.txt"

$SQLScriptFile = $currentPath + "\RestoreDB.txt"


$TargetSQLInstance = @((Get-Content $environmentFileName) | where { $_ -match "TargetSQLInstance=\s*(?<Device>.+)\s*" } | % { $matches["Device"] })
$TargetSQLInstance = $TargetSQLInstance[0].replace("`n",", ").replace("`r",", ")
"Target SQL Instance is " + $TargetSQLInstance

$TargetDBName = @((Get-Content $environmentFileName) | where { $_ -match "TargetDBName=\s*(?<Device>.+)\s*" } | % { $matches["Device"] })
#$TargetDBName = $TargetDBName[0].replace("`n",", ").replace("`r",", ")
"Target DB Name is " + $TargetDBName

$TargetBackupFile = @((Get-Content $environmentFileName) | where { $_ -match "TargetBackupFile=\s*(?<Device>.+)\s*" } | % { $matches["Device"] })
#$TargetBackupFile = $TargetBackupFile[0].replace("`n",", ").replace("`r",", ")
"Target Backup File is " + $TargetBackupFile

$SQLScript = @((Get-Content $environmentFileName) | where { $_ -match "SQLScript=\s*(?<Device>.+)\s*" } | % { $matches["Device"] })
$SQLScript = $SQLScript[0].replace("`n",", ").replace("`r",", ")
"SQL Code Script is " + $SQLScript

$TargetDBPath_MDF = @((Get-Content $environmentFileName) | where { $_ -match "TargetDBPath_MDF=\s*(?<Device>.+)\s*" } | % { $matches["Device"] })
$TargetDBPath_MDF = $TargetDBPath_MDF[0].replace("`n",", ").replace("`r",", ")
"Target DB Path MDF is " + $TargetDBPath_MDF

$TargetDBPath_LDF = @((Get-Content $environmentFileName) | where { $_ -match "TargetDBPath_LDF=\s*(?<Device>.+)\s*" } | % { $matches["Device"] })
$TargetDBPath_LDF = $TargetDBPath_LDF[0].replace("`n",", ").replace("`r",", ")
"Target DB Path LDF is " + $TargetDBPath_LDF

$TargetSQLInstance = @((Get-Content $environmentFileName) | where { $_ -match "TargetSQLInstance=\s*(?<Device>.+)\s*" } | % { $matches["Device"] })
$TargetSQLInstance = $TargetSQLInstance[0].replace("`n",", ").replace("`r",", ")
"Target SQL Instance is " + $TargetSQLInstance


$ServicesToStop = @((Get-Content $environmentFileName) | where { $_ -match "ServicesToStop=\s*(?<Device>.+)\s*" } | % { $matches["Device"] })
$ServicesToStop = $ServicesToStop[0].replace("`n",", ").replace("`r",", ")

############## SQL settings



########## Stop Target Services
$ServicesToStop = @((Get-Content $environmentFileName) | where { $_ -match "ServicesToStop=\s*(?<Device>.+)\s*" } | %{ $matches["Device"] })

foreach ($ServiceToStop in $ServicesToStop)
{
	"Target server and service is " + $ServiceToStop
	$count = 1
	$ServiceToStopSplit = $ServiceToStop.Split(",")
	foreach($splitTarget in $ServiceToStopSplit)
	{
		#if($count -eq 1)
		#{
		#	$targetAOSServer = $splitTarget
		#}
		#else
		#{
			$targetService = $splitTarget
		#}
		$count++
	
	
	
	    "Target service is " + $targetService
	
	    "Stop service " + $targetService
	    $ServiceObj = Get-Service -Name $targetService -erroraction stop
	    if ($ServiceObj.Status -eq "Running")
	    {
	      Stop-Service -InputObj $ServiceObj #-erroraction stop
	    }

	    $ServiceObj = Get-Service  -Name $targetService
	    if ($ServiceObj.Status -ne "Stopped")
	    {
	      throw "Cannot stop the Service " + $targetService
	    }
    }
}

sqlcmd -S $TargetSQLInstance -E -d 'master' -i $SQLScriptFile 
########## Restore


########## Start Target AOS


$ServicesToStop = @((Get-Content $environmentFileName) | where { $_ -match "ServicesToStop=\s*(?<Device>.+)\s*" } | %{ $matches["Device"] })

foreach ($ServiceToStop in $ServicesToStop)
{
	"Target server and service is " + $ServiceToStop
	$count = 1
	$ServiceToStopSplit = $ServiceToStop.Split(",")
	foreach($splitTarget in $ServiceToStopSplit)
	{
		#if($count -eq 1)
		#{
		#	$targetAOSServer = $splitTarget
		#}
		#else
		#{
			$targetService = $splitTarget
		#}
		$count++
	
	
	
	"Target service is " + $targetService
	
	"Start service " + $targetService
	$ServiceObj = Get-Service -Name $targetService -erroraction stop
	if ($ServiceObj.Status -eq "Stopped")
	{
	  Start-Service -InputObj $ServiceObj -erroraction stop
	}

	$ServiceObj = Get-Service  -Name $targetService
	if ($ServiceObj.Status -ne "Running")
	{
	  throw "Cannot start the Service " + $targetService
	}
        }
}


"Operation completed"
